//////////////////////////////////////////////
// CompositeEncoder.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkImagesTests.CompositeEncoder = class CompositeEncoder extends nkDebug.TestClass
{
	static instance = new CompositeEncoder ("nkImagesTests.CompositeEncoder") ;

	nkTests =
	{
		DecodeBmp : async function ()
		{
			const data = await window.nkWeb.readFile("nkData/Textures/Bmp/48x48_rgb_standard.bmp") ;
			nkDebug.TestUtils.check(data.length !== 0, "Could not find source file") ;

			const dataView = new nkMemory.BufferView (data) ;
			const image = nkImages.CompositeEncoder.decode(dataView) ;

			nkDebug.TestUtils.check(image.getWidth() == 48, "Wrong width") ;
			nkDebug.TestUtils.check(image.getHeight() == 48, "Wrong height") ;
			nkDebug.TestUtils.check(image.getDepthOrArraySize() == 1, "Wrong depth") ;
			nkDebug.TestUtils.check(image.getFormat() == nkImages.PIXEL_FORMAT.R8G8B8, "Wrong format") ;
		},

		DecodeDds : async function ()
		{
			const data = await window.nkWeb.readFile("nkData/Textures/Dds/48x48_rgba_dxt5.dds") ;
			nkDebug.TestUtils.check(data.length !== 0, "Could not find source file") ;

			const dataView = new nkMemory.BufferView (data) ;
			const image = nkImages.CompositeEncoder.decode(dataView) ;

			nkDebug.TestUtils.check(image.getWidth() == 48, "Wrong width") ;
			nkDebug.TestUtils.check(image.getHeight() == 48, "Wrong height") ;
			nkDebug.TestUtils.check(image.getDepthOrArraySize() == 1, "Wrong depth") ;
			nkDebug.TestUtils.check(image.getFormat() == nkImages.PIXEL_FORMAT.BC3, "Wrong format") ;

			nkWebUnitTests.ImageHandlingUtils.checkPixel(image, new nkMaths.Vector(0, 0, 0, 0), 0, 0) ;
			nkWebUnitTests.ImageHandlingUtils.checkPixel(image, new nkMaths.Vector(0, 0, 0, 255), 8, 19) ;
			nkWebUnitTests.ImageHandlingUtils.checkPixel(image, new nkMaths.Vector(0, 0, 0, 84), 23, 7) ;
			nkWebUnitTests.ImageHandlingUtils.checkPixel(image, new nkMaths.Vector(0, 0, 0, 255), 30, 27) ;
		},

		DecodeHdr : async function ()
		{
			const data = await window.nkWeb.readFile("nkData/Textures/Hdr/102x51_rgb_rle.hdr") ;
			nkDebug.TestUtils.check(data.length !== 0, "Could not find source file") ;

			const dataView = new nkMemory.BufferView (data) ;
			const image = nkImages.CompositeEncoder.decode(dataView) ;

			nkDebug.TestUtils.check(image.getWidth() == 102, "Wrong width") ;
			nkDebug.TestUtils.check(image.getHeight() == 51, "Wrong height") ;
			nkDebug.TestUtils.check(image.getDepthOrArraySize() == 1, "Wrong depth") ;
			nkDebug.TestUtils.check(image.getFormat() == nkImages.PIXEL_FORMAT.R32G32B32, "Wrong format") ;

			nkWebUnitTests.ImageHandlingUtils.checkPixel(image, new nkMaths.Vector(0.64063, 0.67188, 1.13281, 1), 0, 0) ;
			nkWebUnitTests.ImageHandlingUtils.checkPixel(image, new nkMaths.Vector(1.74219, 1.17969, 1.32031, 1), 53, 23) ;
			nkWebUnitTests.ImageHandlingUtils.checkPixel(image, new nkMaths.Vector(0.0625, 0.0415, 0.04443, 1), 97, 36) ;
		},

		DecodeJpg : async function ()
		{
			const data = await window.nkWeb.readFile("nkData/Textures/Jpg/192x80_colors_422.jpg") ;
			nkDebug.TestUtils.check(data.length !== 0, "Could not find source file") ;

			const dataView = new nkMemory.BufferView (data) ;
			const image = nkImages.CompositeEncoder.decode(dataView) ;

			nkDebug.TestUtils.check(image.getWidth() == 192, "Wrong width") ;
			nkDebug.TestUtils.check(image.getHeight() == 80, "Wrong height") ;
			nkDebug.TestUtils.check(image.getDepthOrArraySize() == 1, "Wrong depth") ;
			nkDebug.TestUtils.check(image.getFormat() == nkImages.PIXEL_FORMAT.R8G8B8, "Wrong format") ;
		},

		DecodePng : async function ()
		{
			const data = await window.nkWeb.readFile("nkData/Textures/Png/192x80_colors_422.png") ;
			nkDebug.TestUtils.check(data.length !== 0, "Could not find source file") ;

			const dataView = new nkMemory.BufferView (data) ;
			const image = nkImages.CompositeEncoder.decode(dataView) ;

			nkDebug.TestUtils.check(image.getWidth() == 192, "Wrong width") ;
			nkDebug.TestUtils.check(image.getHeight() == 80, "Wrong height") ;
		},
	}
}